package kz.arta.ext.jdm.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.file.*;

/**
 * Created by timur on 10/10/16.
 */
public class FileUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    public void moveFileBeforeStart(String fileName) {
        try {
            Files.move(FileSystems.getDefault().getPath(Config.getInstance().getDeploymentsPath(), fileName),
                    FileSystems.getDefault().getPath(Config.getInstance().getTmpPath()), StandardCopyOption.REPLACE_EXISTING);
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }

    public void moveFileOnDeployed(String fileName) {
        try {
            Files.move(FileSystems.getDefault().getPath(Config.getInstance().getTmpPath(), fileName),
                    FileSystems.getDefault().getPath(Config.getInstance().getDeploymentsPath()), StandardCopyOption.REPLACE_EXISTING);
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }
}
