package kz.arta.ext.jdm.after;

import kz.arta.ext.jdm.config.model.Deployment;
import kz.arta.ext.jdm.config.model.Deployments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by timur on 10/11/16.
 */
public class DeploymentsList {


    private HashMap <String, Item> items = new HashMap<>();

    public DeploymentsList(Deployments deployments) {

        for (Deployment deployment: deployments.getDeployments()) {
            Item item = null;
            if (items.containsKey(deployment.getName())) {
                item = items.get(deployment.getName());
            } else {
                item = new Item();
                item.fileName = deployment.getName();
                items.put(item.fileName, item);
            }
            item.dependsOnList.add(deployment.getDependsOn());
        }
    }


    public List<Item> getAllList() {
        return new ArrayList<>(items.values());
    }

    public List<Item> getNotDeployedList() {
        List<Item> list = new ArrayList<>();
        for (String key: items.keySet()){
            if (!items.get(key).isDeployed()) {
                list.add(items.get(key));
            }
        }
        return list;
    }


    public class Item {

        String fileName;

        List<String> dependsOnList = new ArrayList<>();

        boolean isDeployed;

        public String getFileName() {
            return fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public List<String> getDependsOnList() {
            return dependsOnList;
        }

        public void setDependsOnList(List<String> dependsOnList) {
            this.dependsOnList = dependsOnList;
        }

        public boolean isDeployed() {
            return isDeployed;
        }

        public void setDeployed(boolean deployed) {
            isDeployed = deployed;
        }
    }
}
