package kz.arta.ext.jdm.after;

import kz.arta.ext.jdm.common.FileUtil;
import kz.arta.ext.jdm.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.List;

/**
 * Created by timur on 10/10/16.
 */
public class DirectoryViewer {

    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryViewer.class);

    public boolean checkDeploymentsDir() {
        LOGGER.info("Looking for newly deployed files...");
        List<DeploymentsList.Item> items = Config.getInstance().getDeploymentsList().getNotDeployedList();
        LOGGER.debug(String.format("Number of not satisfied deployments is %s", items.size()));
        for (DeploymentsList.Item item: items) {
            boolean satisfied = true;
            for (String dependency: item.getDependsOnList()) {
                if (!isDeployed(dependency)) {
                    satisfied = false;
                }
            }
            if (satisfied) {
                LOGGER.debug(String.format("Newly satisfied dependency %s", item.getFileName()));
                new FileUtil().moveFileOnDeployed(item.fileName);
                item.setDeployed(true);
            }
        }

        items = Config.getInstance().getDeploymentsList().getNotDeployedList();
        LOGGER.debug(String.format("Number of not satisfied dependencies now is %s", items.size()));
        return items.size() == 0;
    }

    private boolean isDeployed(String fileName) {
        File deployedFile = new File(Config.getInstance().getDeploymentsPath(), fileName + ".deployed");
        return deployedFile.exists();
    }
}
