package kz.arta.ext.jdm.config;

import kz.arta.ext.jdm.after.DeploymentsList;
import kz.arta.ext.jdm.config.model.Deployments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.xml.bind.JAXB;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;

/**
 * Created by timur on 10/10/16.
 */
public class Config {

    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);

    private String filePath = "/opt/synergy/jdm/deployments.xml";

    private String deploymentsPath = "/opt/synergy/jboss/standalone/deployments";

    private String tmpPath = "/opt/tmpDeployments";

    private String currentOption = "before";

    private DeploymentsList deploymentsList;

    private Config() {

    }

    private static Config config = null;

    public static Config getInstance() {
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    private void readConfig() {

        FileInputStream fin = null;

        try {

            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            fin = new FileInputStream(filePath);
            byte[] buffer = new byte[1024];
            int read;
            while ((read = fin.read(buffer, 0, buffer.length)) != -1) {
                bout.write(buffer, 0, read);
            }

            Deployments deployments = JAXB.unmarshal(new ByteArrayInputStream(bout.toByteArray()), Deployments.class);
            deploymentsList = new DeploymentsList(deployments);

        } catch (Exception exc){
            LOGGER.error(exc.getMessage(), exc);
        } finally {
            try {
                fin.close();
            } catch (IOException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
    }

    public String getDeploymentsPath() {
        return deploymentsPath;
    }

    public String getTmpPath() {
        return tmpPath;
    }

    public String getCurrentOption() {
        return currentOption;
    }

    public void setCurrentOption(String currentOption) {
        this.currentOption = currentOption;
    }

    public DeploymentsList getDeploymentsList() {
        return deploymentsList;
    }

    public void readParams(String [] args) {
        try {
            currentOption = args[0];
            filePath = args[1];
            tmpPath = args[2];
            deploymentsPath = args[3];
        } catch (Exception exc){
            System.err.println("You should pass 4 parameters:\n" +
                    " 0: option (before - pass this value before jboss starts, this will move all files with dependencies from deployments to tmp directory; \n" +
                    " \tafter - pass this value after jboss started, this will observe deployments directory and move files from tmp to deployments when needed) \n" +
                    " 1: path to config file with deployment dependencies\n" +
                    " 2: path to tmp directory\n" +
                    " 3: path to deployments directory\n");
            throw new RuntimeException("Invalid parameters", exc);
        }
        readConfig();
    }
}
