package kz.arta.ext.jdm.before;

import kz.arta.ext.jdm.after.DeploymentsList;
import kz.arta.ext.jdm.common.FileUtil;
import kz.arta.ext.jdm.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * Created by timur on 10/12/16.
 */
public class DeploymentsMover {

    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentsMover.class);

    public void move() {
        LOGGER.debug("Start moving files with deployment dependencies");
        FileUtil fileUtil = new FileUtil();
        List<DeploymentsList.Item> items = Config.getInstance().getDeploymentsList().getAllList();
        LOGGER.debug(String.format("Files list size is %s", items.size()));
        for (DeploymentsList.Item item: items) {
            LOGGER.debug(String.format("Moving %s", item.getFileName()));
            fileUtil.moveFileBeforeStart(item.getFileName());
        }
    }
}
