package kz.arta.ext.jdm.common;

import kz.arta.ext.jdm.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.file.*;

/**
 * Created by timur on 10/10/16.
 */
public class FileUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    public void moveFileBeforeStart(String fileName) {
        LOGGER.trace(String.format("Move %s to tmp directory", fileName));
        try {
            Files.move(FileSystems.getDefault().getPath(Config.getInstance().getDeploymentsPath(), fileName),
                    FileSystems.getDefault().getPath(Config.getInstance().getTmpPath(), fileName), StandardCopyOption.REPLACE_EXISTING);
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }

    public void moveFileOnDeployed(String fileName) {
        LOGGER.trace(String.format("Move %s to deployments directory", fileName));
        try {
            Files.move(FileSystems.getDefault().getPath(Config.getInstance().getTmpPath(), fileName),
                    FileSystems.getDefault().getPath(Config.getInstance().getDeploymentsPath(), fileName), StandardCopyOption.REPLACE_EXISTING);
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }
}
