package kz.arta.synergy.api.rest.sample.delegation;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by root on 8/1/14.
 */
public class DelegationServiceGetDelegateActions {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** uuid пользователя - обязательный параметр*/
    private String userID;
    /** uuid пользователя, кем были делегированы права, если не указано возвращаются все права пользователя*/
    private String delegatedID = null;
    /** тип объекта, если 0 возвращаются права по всем типам*/
    private String objectType = "0";

    public DelegationServiceGetDelegateActions(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        this.encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public String getUserID() {
        return userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getDelegatedID() {
        return delegatedID;
    }

    public void setDelegatedID(String delegatedID) {
        this.delegatedID = delegatedID;
    }

    public String getObjectType() {
        return objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public void getDelegatedActions() throws Exception {

        if (delegatedID != null) {
            delegatedID = "&delegatedID=" + delegatedID;
        } else {
            delegatedID = "";
        }
        URL url = new URL(address + "/rest/api/delegation/get_delegated_actions?userID="
                + userID + "&objectType=" + objectType + delegatedID);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept" , "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setDoInput(true);
        connection.setUseCaches(false);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        System.out.println(response.toString());
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }

    }
}
