package kz.arta.synergy.api.rest.sample.diary;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by root on 7/31/14.
 */
public class DiaryServiceCreateTask {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    /** Переменная URL Arta Synergy. */
    private String address;
    private String encoded;
    /** текст задачи*/
    private String task;
    /** идентификатор задачи (в случае добавления новой задачи должен отсутствовать)*/
    private String taskID;
    /** дата начала в формате yyyy-MM-dd либо yyyy-MM-dd HH:mm:00 (первый для задач в течение дня, второй для задач с конкретным временем)*/
    private String start;
    /** дата завершения в формате yyyy-MM-dd либо yyyy-MM-dd HH:mm:00 (первый для задач в течение дня, второй для задач с конкретным временем)*/
    private String finish;
    /** в течение целого дня или нет*/
    private boolean wholeDay;
    /** идентификатор пользователя для которого создается задача*/
    private String userID;

    public DiaryServiceCreateTask(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        this.encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void createTask() throws Exception {
        URL url = new URL(address + "/rest/api/diary/tasks/" + userID + "/save");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setDoInput(true);
        connection.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("task=" + task);
        request.writeBytes("&");
        if (taskID != null) {
            request.writeBytes("taskID=" + taskID);
        }
        request.writeBytes("&");
        request.writeBytes("start=" + start);
        request.writeBytes("&");
        request.writeBytes("finish=" + finish);
        request.writeBytes("&");
        request.writeBytes("wholeDay=" + wholeDay);
        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        is.close();
        br.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public void setTask(String task) {
        this.task = task;
    }

    public void setTaskID(String taskID) {
        this.taskID = taskID;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public void setFinish(String finish) {
        this.finish = finish;
    }

    public void setWholeDay(boolean wholeDay) {
        this.wholeDay = wholeDay;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getTask() {
        return task;
    }

    public String getTaskID() {
        return taskID;
    }

    public String getStart() {
        return start;
    }

    public String getFinish() {
        return finish;
    }

    public boolean isWholeDay() {
        return wholeDay;
    }

    public String getUserID() {
        return userID;
    }
}
