package kz.arta.synergy.api.rest.sample.filecabinet;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

/**
 * Created by root on 7/17/15.
 */
public class DepartmentsServiceSaveDepartment {
    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    /** Переменная URL Arta Synergy. */
    private String address;
    private String encoded;

    private String nameRU;
    private String nameKZ;
    private String nameEN;
    private String positionNameRu;
    private String positionNameKz;
    private String positionNameEn;
    private String pointersCode;
    private String departmentID;
    private String parentDepartmentID;
    private int number;

    public DepartmentsServiceSaveDepartment(String address, String login, String password) {
        this.address = address;
        this.login = login ;
        this.password = password;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void saveDepartments() throws Exception {
        URL url = new URL(address + "/rest/api/departments/save");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("nameRu=" + URLEncoder.encode(nameRU, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("nameKz=" + URLEncoder.encode(nameKZ, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("nameEn=" + URLEncoder.encode(nameEN, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("positionNameRu=" + URLEncoder.encode(positionNameRu, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("positionNameKz=" + URLEncoder.encode(positionNameKz, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("positionNameEn=" + URLEncoder.encode(positionNameEn, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("pointersCode=" + pointersCode);
        request.writeBytes("&");
        request.writeBytes("numer=" + number);
        request.writeBytes("&");
        request.writeBytes("departmentID=" + departmentID);
        request.writeBytes("&");
        request.writeBytes("parentDepartmentID=" + parentDepartmentID);
        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        is.close();
        br.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public int getNumber() {
        return number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getParentDepartmentID() {
        return parentDepartmentID;
    }

    public void setParentDepartmentID(String parentDepartmentID) {
        this.parentDepartmentID = parentDepartmentID;
    }

    public String getDepartmentID() {
        return departmentID;
    }

    public void setDepartmentID(String departmentID) {
        this.departmentID = departmentID;
    }

    public String getPointersCode() {
        return pointersCode;
    }

    public void setPointersCode(String pointersCode) {
        this.pointersCode = pointersCode;
    }

    public String getPositionNameEn() {
        return positionNameEn;
    }

    public void setPositionNameEn(String positionNameEn) {
        this.positionNameEn = positionNameEn;
    }

    public String getPositionNameKz() {
        return positionNameKz;
    }

    public void setPositionNameKz(String positionNameKz) {
        this.positionNameKz = positionNameKz;
    }

    public String getPositionNameRu() {
        return positionNameRu;
    }

    public void setPositionNameRu(String positionNameRu) {
        this.positionNameRu = positionNameRu;
    }

    public String getNameEN() {
        return nameEN;
    }

    public void setNameEN(String nameEN) {
        this.nameEN = nameEN;
    }

    public String getNameKZ() {
        return nameKZ;
    }

    public void setNameKZ(String nameKZ) {
        this.nameKZ = nameKZ;
    }

    public String getNameRU() {
        return nameRU;
    }

    public void setNameRU(String nameRU) {
        this.nameRU = nameRU;
    }
}

