package kz.arta.synergy.api.rest.sample.filecabinet;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by root on 7/30/14.
 */
public class PositionsServiceDeletePosition {
    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    private String positionID;

    public PositionsServiceDeletePosition(String login, String password, String address) {
        this.address = address;
        this.login = login;
        this.password = password;
        this.encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void deletePosition() throws Exception {
        URL url = new URL(address + "/rest/api/positions/delete?positionID=" + positionID);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setDoInput(true);
        connection.setDoOutput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        System.out.println(response.toString());
    }

    public void setPositionID(String positionID) {
        this.positionID = positionID;
    }

    public String getPositionID() {
        return this.positionID;
    }
}
