package kz.arta.synergy.api.rest.sample.filecabinet;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Метод возвращает информацию о должности
 *
 * Created by user1 on 04.09.14.
 */
public class PositionsServiceGetPosition {

    private String login;
    private String password;
    private String address;
    //UUID должности, которую необходимо удалить (QueryParam)
    private String positionID;

    public PositionsServiceGetPosition(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
    }

    public void getPosition() throws Exception {
        String encoded = Base64.encode((login + ":" + password).getBytes());
        URL url = new URL(address + "/rest/api/positions/get?positionID=" + positionID);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept","application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer buffer = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            buffer.append(line);
        }

        is.close();
        br.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(buffer.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public String getPositionID() {
        return positionID;
    }

    public void setPositionID(String positionID) {
        this.positionID = positionID;
    }
}
