package kz.arta.synergy.api.rest.sample.filecabinet;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

/**
 *
 * Метод создает/изменяет должность (специалиста/руководителя) орг структуры
 *
 * Created by user1 on 04.09.14.
 */
public class PositionsServiceSavePosition {

    private String login;
    private String password;
    private String address;
    //Название должности на русском языке, FormParam
    private String nameRu;
    //Название должности на казахском языке, FormParam
    private String nameKz;
    //Название должности на английском языке, FormParam
    private String nameEn;
    //код показателя, FormParam
    private String pointersCode = null;
    //UUID должности, FormParam
    private String positionID = null;
    //UUID родительского подразделения, FormParam
    private String departmentID = null;
    //тип должности, FormParam
    private String positionType = null;
    //порядковый номер дожности, может отсутствовать, FormParam
    private int number;

    public PositionsServiceSavePosition(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
    }

    public void savePostion() throws Exception {
        URL url = new URL(address + "/rest/api/positions/save");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        String encoded = Base64.encode((login + ":" + password).getBytes());
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setDoOutput(true);
        connection.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("nameRu=" + URLEncoder.encode(nameRu, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("nameKz=" + URLEncoder.encode(nameKz, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("nameEn=" + URLEncoder.encode(nameEn, "utf-8"));
        if (number != 0) {
            request.writeBytes("&");
            request.writeBytes("number=" + number);
        }
        if (departmentID != null) {
            request.writeBytes("&");
            request.writeBytes("departmentID=" + departmentID);
        }
        if (positionID != null) {
            request.writeBytes("&");
            request.writeBytes("positionID=" + positionID);
        }
        if (positionType != null) {
            request.writeBytes("&");
            request.writeBytes("positionType=" + positionType);
        }

        if (pointersCode != null) {
            request.writeBytes("&");
            request.writeBytes("pointersCode=" + URLEncoder.encode(pointersCode, "utf-8"));
        }
        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer buffer = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            buffer.append(line);
        }

        is.close();
        br.close();

        System.out.println(buffer.toString());
    }

    public String getNameRu() {
        return nameRu;
    }

    public void setNameRu(String nameRu) {
        this.nameRu = nameRu;
    }

    public String getNameKz() {
        return nameKz;
    }

    public void setNameKz(String nameKz) {
        this.nameKz = nameKz;
    }

    public String getNameEn() {
        return nameEn;
    }

    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public String getPointersCode() {
        return pointersCode;
    }

    public void setPointersCode(String pointersCode) {
        this.pointersCode = pointersCode;
    }

    public String getPositionID() {
        return positionID;
    }

    public void setPositionID(String positionID) {
        this.positionID = positionID;
    }

    public String getDepartmentID() {
        return departmentID;
    }

    public void setDepartmentID(String departmentID) {
        this.departmentID = departmentID;
    }

    public String getPositionType() {
        return positionType;
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType;
    }

    public int getNumber() {
        return number;
    }

    public void setNumber(int number) {
        this.number = number;
    }
}
