package kz.arta.synergy.api.rest.sample.filecabinet;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

/**
 *
 * класс демонстрации работы метода createUser класса UserService
 *
 * Created by root on 7/17/15.
 */
public class UserServiceCreateUser {
    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** фамилия*/
    private String lastname;
    /** имя*/
    private String firstname;
    /** отчество*/
    private String patronymic;
    /** код показателя*/
    private String pointersCode;
    /** является ли сотрудником канцелярии*/
    private boolean isChancellery;
    /** является ли методологом*/
    private boolean isConfigurator;
    /** является ли администратором системы*/
    private boolean isAdmin;
    /** почтовый адрес для уведомлений*/
    private String email;
    /** адрес jabber аккаунта*/
    private String jid;
    /** личная папка*/
    private String privateFolder;
    /** имеет ли доступ в систему*/
    private boolean hasAccess;
    /** имеет ли доступ к справочнику показателей*/
    private boolean hasPointersBookAccess;
    /** имеет ли доступ к стратегии*/
    private boolean hasStrategyAccess;
    /** UUID подразделений, в которых является сотрудником ОКК*/
    private List<String> hrDepartmentID = null;
    /** идентификатор пользователя. Необходимо передавать если должно выполниться изменение существующего пользователя*/
    private String userID = null;

    public UserServiceCreateUser(String address, String login, String password) {
        this.address = address;
        this.login = login;
        this.password = password;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void createUser() throws Exception {
        URL url = new URL(address + "/rest/api/filecabinet/user/save");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("lastname=" + lastname);
        request.writeBytes("&");
        request.writeBytes("firstname=" + firstname);
        request.writeBytes("&");
        request.writeBytes("patronymic=" + patronymic);
        request.writeBytes("&");
        request.writeBytes("pointersCode=" + pointersCode);
        request.writeBytes("&");
        request.writeBytes("isChancellery=" + isChancellery);
        request.writeBytes("&");
        request.writeBytes("isConfigurator=" + isConfigurator);
        request.writeBytes("&");
        request.writeBytes("isAdmin=" + isAdmin);
        request.writeBytes("&");
        request.writeBytes("email=" + email);
        request.writeBytes("&");
        request.writeBytes("jid=" + jid);
        request.writeBytes("&");
        request.writeBytes("privateFolder=" + privateFolder);
        request.writeBytes("&");
        request.writeBytes("hasAccess=" + hasAccess);
        request.writeBytes("&");
        request.writeBytes("hasPointersBookAccess=" + hasPointersBookAccess);
        request.writeBytes("&");
        request.writeBytes("hasStrategyAccess=" + hasStrategyAccess);

        if (hrDepartmentID != null) {
            for (String str : hrDepartmentID) {
                request.writeBytes("&");
                request.writeBytes("hrDepartmentID=" + str);
            }
        }

        if (userID != null) {
            request.writeBytes("&");
            request.writeBytes("userID=" + userID);
        }
        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        is.close();
        br.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public String getLastname() {
        return lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getFirstname() {
        return firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getPatronymic() {
        return patronymic;
    }

    public void setPatronymic(String patronymic) {
        this.patronymic = patronymic;
    }

    public String getPointersCode() {
        return pointersCode;
    }

    public void setPointersCode(String pointersCode) {
        this.pointersCode = pointersCode;
    }

    public boolean isChancellery() {
        return isChancellery;
    }

    public void setChancellery(boolean isChancellery) {
        this.isChancellery = isChancellery;
    }

    public boolean isConfigurator() {
        return isConfigurator;
    }

    public void setConfigurator(boolean isConfigurator) {
        this.isConfigurator = isConfigurator;
    }

    public boolean isAdmin() {
        return isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getJid() {
        return jid;
    }

    public void setJid(String jid) {
        this.jid = jid;
    }

    public String getPrivateFolder() {
        return privateFolder;
    }

    public void setPrivateFolder(String privateFolder) {
        this.privateFolder = privateFolder;
    }

    public boolean isHasAccess() {
        return hasAccess;
    }

    public void setHasAccess(boolean hasAccess) {
        this.hasAccess = hasAccess;
    }

    public boolean isHasPointersBookAccess() {
        return hasPointersBookAccess;
    }

    public void setHasPointersBookAccess(boolean hasPointersBookAccess) {
        this.hasPointersBookAccess = hasPointersBookAccess;
    }

    public boolean isHasStrategyAccess() {
        return hasStrategyAccess;
    }

    public void setHasStrategyAccess(boolean hasStrategyAccess) {
        this.hasStrategyAccess = hasStrategyAccess;
    }

    public List<String> getHrDepartmentID() {
        return hrDepartmentID;
    }

    public void setHrDepartmentID(List<String> hrDepartmentID) {
        this.hrDepartmentID = hrDepartmentID;
    }

    public String getUserID() {
        return userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }
}
