package kz.arta.synergy.api.rest.sample.filecabinet;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Возвращает основную информацию по пользователю в json
 *
 * Created by user1 on 04.09.14.
 */
public class UsersServiceGetUser {

    private String login;
    private String password;
    private String address;
    //идентфикатор пользователя
    private String userID;

    public UsersServiceGetUser(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
    }

    public void getUser() throws Exception {
        URL url = new URL(address + "/rest/api/filecabinet/user/" + userID);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        String encoded = Base64.encode((login + ":" + password).getBytes());
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        is.close();
        br.close();

        System.out.println(response.toString());
    }

    public String getUserID() {
        return userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }
}
