package kz.arta.synergy.api.rest.sample.filecabinet.auth;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by user1 on 03.09.14.
 */

public class PersonServiceGenerateUserAuthKey {

    private String login;
    private String password;
    private String address;

    public PersonServiceGenerateUserAuthKey(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
    }

    public void generateAuthKey() throws Exception {
        URL url = new URL(address + "/rest/api/person/auth");
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json; charset=utf-8");
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Cache-Control", "no-cache");
        String encoded = Base64.encode((login + ":" + password).getBytes());
        conn.setRequestProperty("Authorization", "Basic " + encoded);

        String output;
        StringBuffer result = new StringBuffer();

        BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));

        while ((output = br.readLine()) != null) {
            result.append(output);
        }

        conn.disconnect();
        System.out.println(result.toString());

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(result.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null){
            if (token == JsonToken.FIELD_NAME){
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }
}