package kz.arta.synergy.api.rest.sample.map;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by root on 7/31/14.
 */
public class PointersServiceSearch {
    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;

    /** поисковая строка (может отсутствовать для получения всего списка)*/
    private String search = null;
    /** тип показателей: 2 - базовый, 4 - внешний, 1- расчитываемый (может отсутствовать для получения полного списка)*/
    private String type = null;
    /** необходимо передать значение данного параметра true, чтобы метод вернул все поля показателей. Иначе возвращаются
     *  только поля общие для показателей всех типов: идентификатор, название, код, единица измерения
     */
    private boolean loadFullInfo = false;
    /** номер страницы возвращаемых результатов (отсчет с 0)*/
    private String partNumber = null;
    /** количество результатов в одной странице */
    private String countInPart = null;

    public PointersServiceSearch(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        this.encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void deletePointer() throws Exception {

        StringBuffer params = new StringBuffer();

        if (search != null) {
            params.append("&search=" + search);
        }

        if (partNumber != null) {
            params.append("&partNumber=" + partNumber);
        }

        if (countInPart != null) {
            params.append("&countInPart=" + countInPart);
        }

        URL url = new URL(address + "/rest/api/pointers/search?type=" + type + "&loadFullInfo="
                + loadFullInfo + params.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept" , "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setDoInput(true);
        connection.setUseCaches(false);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public String getSearch() {
        return search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isLoadFullInfo() {
        return loadFullInfo;
    }

    public void setLoadFullInfo(boolean loadFullInfo) {
        this.loadFullInfo = loadFullInfo;
    }

    public String getPartNumber() {
        return partNumber;
    }

    public void setPartNumber(String partNumber) {
        this.partNumber = partNumber;
    }

    public String getCountInPart() {
        return countInPart;
    }

    public void setCountInPart(String countInPart) {
        this.countInPart = countInPart;
    }
}
