package kz.arta.synergy.api.rest.sample.notifications;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

/**
 * Created by root on 8/3/14.
 */
public class NotificationsServiceGet {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** Время последнего получения уведомлений в миллисекундах, если ранее уведомления не запрашивались значние передавать не надо - система сама определит количество последних уведомлений, которые надо вернуть*/
    private String lastGetTime = null;
    /** true - система вернет только те типы уведомлений на получение которых пользователь подписан, согласно настройкам в системе, false - вернет все типы уведомлений*/
    private boolean subscribedOnly = false;
    /** идентификатор типа уведомления (action_types.typeID), передача этого ограничивает возвращаемые уведомления данным типом/типами. Если необходимо передать несколько типов уведомлений - параметр надо указать в запросе несколько раз*/
    private List<Integer> actionTypes = null;
    /** идентификатор объекта, передача этого параметра ограничиывает возвращаемые уведомления по типу объекта, к которому они относятся. Если необходимо передать несколько типов объектов - параметр надо указать в запросе несколько раз Обрабатываются значения парамтра:
     4 - работа, проекты
     8 - задача
     2 - цель
     16 - показатель*/
    private List<Integer> objectTypes = null;

    public NotificationsServiceGet(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        this.encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void get() throws Exception {

        StringBuffer params = new StringBuffer();

        params.append("?subscribedOnly=" + subscribedOnly);

        if (lastGetTime != null) {
            params.append("&lastGetTime=" + lastGetTime);
        }

        if (actionTypes != null) {
            for (Integer type : actionTypes) {
                params.append("&actionType=" + type);
            }
        }

        if (objectTypes != null) {
            for (Integer type : objectTypes) {
                params.append("&objectType=" + type);
            }
        }

        URL url = new URL(address + "/rest/api/notifications/get" + params.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept" , "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setDoInput(true);
        connection.setUseCaches(false);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public String getLastGetTime() {
        return lastGetTime;
    }

    public void setLastGetTime(String lastGetTime) {
        this.lastGetTime = lastGetTime;
    }

    public boolean isSubscribedOnly() {
        return subscribedOnly;
    }

    public void setSubscribedOnly(boolean subscribedOnly) {
        this.subscribedOnly = subscribedOnly;
    }

    public List<Integer> getActionTypes() {
        return actionTypes;
    }

    public void setActionTypes(List<Integer> actionTypes) {
        this.actionTypes = actionTypes;
    }

    public List<Integer> getObjectTypes() {
        return objectTypes;
    }

    public void setObjectTypes(List<Integer> objectTypes) {
        this.objectTypes = objectTypes;
    }
}
