package kz.arta.synergy.api.rest.sample.storage;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * класс демонстрации работы метода getGroups класса StorageGroupService
 *
 * Created by root on 7/17/15.
 */
public class StorageGroupServiceGetGroups {
    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    /** Переменная URL Arta Synergy. */
    private String address;
    private String encoded;
    /** количество записей в списке */
    private int recordsCount = -1;
    /** номер первой записи*/
    private int startRecord = -1;

    public StorageGroupServiceGetGroups(String address, String login, String password) {
        this.address = address;
        this.login = login;
        this.password = password;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void getGroups() throws Exception{
        StringBuffer paramList = new StringBuffer();
        if (startRecord != -1) {
            paramList.append("&startRecord=" + startRecord);
        }

        if (recordsCount != -1) {
            paramList.append("&recordCount=" + recordsCount);
        }
        if (paramList.length() != 0) {
            paramList.deleteCharAt(0);
        }

        URL url = new URL(address + "/rest/api/storage/groups/list?" + paramList.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        is.close();
        br.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public void setRecordsCount(int recordsCount) {
        this.recordsCount = recordsCount;
    }

    public void setStartRecord(int startRecord) {
        this.startRecord = startRecord;
    }

    public int getStartRecord() {
        return this.startRecord;
    }

    public int getRecordsCount() {
        return this.recordsCount;
    }
}
