package kz.arta.synergy.api.rest.sample.storage;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

/**
 * Created by root on 7/13/15.
 */
public class StorageServiceCreateAttachment {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    /** Переменная URL Arta Synergy. */
    private String address;
    private String encoded;
    /** UUID документа*/
    private String docID;
    /** строка, показывающая в какую подпапку контейнера файлов документа необходимо положить файл*/
    private String path;
    /**  Название загружаемого файла*/
    private String fileName;
    /** Путь к временному файлу, загруженному на сервер*/
    private String filePath;

    private String tmpFilePath;

    public StorageServiceCreateAttachment(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }
    public void createAttachment() throws Exception {
        {
            URL url = new URL(address + "/rest/api/storage/start_upload?locale=ru");
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Cache-Control", "no-cache");
            conn.setRequestProperty("Authorization", "Basic " + encoded);

            String output;
            StringBuffer contactsInfo = new StringBuffer();

            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));

            while ((output = br.readLine()) != null) {
                contactsInfo.append(output);
            }

            conn.disconnect();
            System.out.println(contactsInfo.toString());

            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createJsonParser(contactsInfo.toString());
            JsonToken token = null;


            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getText();
                    token = parser.nextToken();
                    if (fieldName.equals("file") && token == JsonToken.VALUE_STRING){
                        tmpFilePath = parser.getText();
                    }
                }
            }
        }
        System.out.println("Temporary file path -> " + tmpFilePath);

        //загрузка файла по частям
        {
            String boundary = "qweasdzxczxcasdqwe";
            String crlf = "\r\n";
            String twoHyphens = "--";

            FileInputStream fin = new FileInputStream(filePath);
            int partSize = 1024*100;
            byte[] bytes = new byte[partSize];
            int position = 0;
            int read = 0;

            while ((read = fin.read(bytes, 0, partSize)) != -1){

                byte [] readBytes = new byte[read];
                System.arraycopy(bytes, 0, readBytes, 0, read);
                position += read;

                URL url = new URL(address + "/rest/api/storage/upload_part?file=" + URLEncoder.encode(tmpFilePath, "utf-8"));
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Accept", "application/json; charset=utf-8");
                conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
                conn.setRequestProperty("Connection", "Keep-Alive");
                conn.setRequestProperty("Cache-Control", "no-cache");
                conn.setRequestProperty("Authorization", "Basic "+encoded);

                conn.setUseCaches (false);
                conn.setDoInput(true);
                conn.setDoOutput(true);

                DataOutputStream request = new DataOutputStream(conn.getOutputStream());
                request.writeBytes(twoHyphens + boundary + crlf);
                request.writeBytes("Content-Disposition: form-data; name=\"body\";filename=\"" + URLEncoder.encode(fileName, "utf-8")+ "\"" + crlf);
                request.writeBytes(crlf);
                request.write(Base64.encode(readBytes).getBytes());
                request.writeBytes(crlf);
                request.writeBytes(twoHyphens + boundary + twoHyphens + crlf);

                request.flush();
                request.close ();


                InputStream is = conn.getInputStream();
                BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                String line;
                StringBuffer response = new StringBuffer();
                while((line = rd.readLine()) != null) {
                    response.append(line);
                    response.append('\r');
                }
                rd.close();
                System.out.println(response.toString());
            }

        }

        {
            //Добавляем файл к работе
            URL url = new URL(address + "/rest/api/storage/document/" + docID + "/attachment/create");
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Cache-Control", "no-cache");
            conn.setRequestProperty("Authorization", "Basic "+encoded);

            conn.setUseCaches (false);
            conn.setDoInput(true);
            conn.setDoOutput(true);

            DataOutputStream request = new DataOutputStream(conn.getOutputStream());
            request.writeBytes("fileName=" + URLEncoder.encode(new File(filePath).getName(), "utf-8") +
                    "&filePath=" + URLEncoder.encode(tmpFilePath, "utf-8") + "&path=ase:workContainer");
            request.flush();
            request.close ();


            InputStream is = conn.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            String line;
            StringBuffer response = new StringBuffer();
            while((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            System.out.println(response.toString());
        }
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDocID() {
        return docID;
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }
}
