package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;

/**
 * Класс демонстрации работы метода createWork класса WorkFlowService
 *
 * Created by root on 7/2/14.
 */
public class WorkFlowServiceCreateWork {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** название работы. */
    private String name;
    /** дата и время начала работы в формате yyyy-MM-dd HH:mm:ss. */
    private String startDate;
    /** дата и время завершения работы в формате yyyy-MM-dd HH:mm:ss. */
    private String finishDate;
    /** uuid исполнителя работы. */
    private String userID;
    /** приоритет. */
    private String priority;
    private List<String> resUserID;
    private String completionFormID;
    private String force;
    private String moduleID;

    public WorkFlowServiceCreateWork(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void createWork() throws Exception {

        URL url = new URL(address + "/rest/api/workflow/work/create");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Cache-Control", "no-cache");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestMethod("POST");

        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("name=" + URLEncoder.encode(name, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("startDate=" + startDate);
        request.writeBytes("&");
        request.writeBytes("finishDate=" + finishDate);
        request.writeBytes("&");
        request.writeBytes("userID=" + userID);
        request.writeBytes("&");
        request.writeBytes("priority=" + priority);
        if (resUserID != null) {
            for (String str: resUserID) {
                request.writeBytes("&");
                request.writeBytes("resUserID=" + str);
            }
        }

        if (completionFormID != null) {
            request.writeBytes("&");
            request.writeBytes("completionFormID=" + completionFormID);
        }

        if (force != null) {
            request.writeBytes("&");
            request.writeBytes("force=" + force);
        }

        if (moduleID != null) {
            request.writeBytes("&");
            request.writeBytes("moduleID=" + moduleID);
        }

        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
            response.append("\r");
        }

        br.close();
        is.close();
        System.out.println(response.toString());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setFinishDate(String finishDate) {
        this.finishDate = finishDate;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setResUserID(List<String> list) {
        resUserID = list;
    }

    public void setCompletionFormID(String completionFormID) {
        this.completionFormID = completionFormID;
    }

    public void setForce(String yoda) {
        this.force = yoda;
    }

    public void setModuleID(String moduleID) {
        this.moduleID = moduleID;
    }

    public String getName() {
        return this.name;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getFinishDate() {
        return this.finishDate;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getPriority() {
        return this.priority;
    }

    public List<String> getResUserID() {
        return this.resUserID;
    }

    public String getCompletionFormID() {
        return this.completionFormID;
    }

    public String getForce() {
        return this.force;
    }

    public String getModuleID() {
        return this.moduleID;
    }
}
