package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрирующий работу метода getComments класса WorkFlowService
 *
 * Created by root on 7/3/14.
 */
public class WorkFlowServiceGetComments {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;

    /** uuid работы */
    private String workID;
    /** Номер первой записи (отсчет с 0). */
    private String start;
    /** Количество записей в возвращаемом списке. */
    private String count;
    /** true - получить количество комментариев, иначе - false. */
    private String getCounters;

    public WorkFlowServiceGetComments(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void getComments() throws Exception {

        URL url = new URL(address + "/rest/api/workflow/work/" + workID + "/comments?start="
                + start + "&count=" + count + "&getCounters=" + getCounters);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(true);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
            response.append("\r");
        }

        System.out.println(response.toString());
        is.close();
        br.close();
    }

    public void setWorkID(String workID) {
        this.workID = workID;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public void setGetCounters(String getCounters) {
        this.getCounters = getCounters;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getWorkID() {
        return this.workID;
    }

    public String getStart() {
        return this.start;
    }

    public String getGetCounters() {
        return this.getCounters;
    }

    public String getCount() {
        return this.count;
    }
}
