package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрирующий работу метода getFullAttachment класса WorkFlowService
 *
 * Created by root on 7/3/14.
 */
public class WorkFlowServiceGetFullAttachments {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** uuid работы. */
    private String workID;

    public WorkFlowServiceGetFullAttachments(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void getFullAttachments() throws Exception {

        URL url = new URL(address + "/rest/api/workflow/work/" + workID + "/attachments");
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json; charset=utf-8");
        conn.setRequestProperty("Authorization", "Basic "+encoded);

        String output;
        StringBuffer contactsInfo = new StringBuffer();

        BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));

        while ((output = br.readLine()) != null) {
            contactsInfo.append(output);
        }

        conn.disconnect();
        System.out.println(contactsInfo.toString());

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(contactsInfo.toString());
        JsonToken token = null;


        while ((token = parser.nextToken()) != null){
            if (token == JsonToken.FIELD_NAME){
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING){
                    System.out.print(parser.getText());
                }

            }
        }
    }

    public void setWorkID(String workID) {
        this.workID = workID;
    }

    public String getWorkID() {
        return this.workID;
    }
}
