package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрирующий работу метода getSendWorkInfo класса WorkFlowService
 *
 * Created by root on 7/3/14.
 */
public class WorkFlowServiceGetSendWorkInfo {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** Идентификатор работы. */
    private String workID;
    /** Идентификатор действия. */
    private String actionType;
    /** Идентификатор операции. */
    private String operationType;

    public WorkFlowServiceGetSendWorkInfo(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void getSendWorkInfo() throws Exception {

        URL url = new URL(address + "/rest/api/workflow/send_work_info?workID=" + workID
                + "&actionType=" + actionType + "&operationType=" + operationType);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
            response.append("\r");
        }

        br.close();
        is.close();
        System.out.println(response.toString());
    }

    public void setWorkID(String workID) {
        this.workID = workID;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getWorkID() {
        return this.workID;
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getOperationType() {
        return this.operationType;
    }
}
