package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрации работы метода setWorkProgress класса WorkFlowService
 * Created by root on 7/3/14.
 */
public class WorkFlowServiceSetWorkProgress {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** uuid работы. */
    private String workID;
    /** новое значение прогресса (0-100) */
    private String progress;

    public WorkFlowServiceSetWorkProgress(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void setWorkProgress() throws Exception {

        URL url = new URL(address + "/rest/api/workflow/work/set_progress?workID=" + workID
                + "&progress=" + progress);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        System.out.println(response.toString());
        br.close();
        is.close();
    }

    public void setWorkID(String workID) {
        this.workID = workID;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public String getWorkID() {
        return this.workID;
    }

    public String getProgress() {
        return this.progress;
    }
}
