package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрирующий работу метода setWorkState класса WorkFlowService
 *
 * Created by root on 7/3/14.
 */
public class WorkFlowServiceSetWorkState{

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** UUID работы. */
    private String workID;
    /** новый статус работы. */
    private int stateID;

    public WorkFlowServiceSetWorkState(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void setWorkState() throws Exception {
        URL url = new URL(address + "/rest/api/workflow/work/set_state?workID" + workID + "&stateID=" + stateID);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public void setWorkID(String workID) {
        this.workID = workID;
    }

    public void setStateID(int stateID) {
        this.stateID = stateID;
    }

    public String getWorkID() {
        return this.workID;
    }

    public int getStateID() {
        return this.stateID;
    }
}
