package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

/**
 *
 * Класс демонстрации работы метода startRoute класса WorkFlowService
 *
 * Created by root on 7/3/14.
 */
public class WorkFlowServiceStartRoute {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** uuid работы. */
    private String workID;
    /** форма завершения работы. */
    private String completionForm;
    /** Дата завершения работ по маршруту в формате yyyy-MM-dd HH:mm:ss. */
    private String finishDate;
    /** список идентификаторов пользователей, которым отправляется работа. */
    private List<String> resUserID;
    /** тип, одно из значений:  */
    private int type;
    /** название работы. */
    private String name;


    public WorkFlowServiceStartRoute(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void startRoute() throws Exception {

        URL url = new URL(address + "/rest/api/workflow/work/start_route");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Cache-Control", "no-cache");
        connection.setRequestProperty("Authorization", "Basic " + encoded);

        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("finishDate=" + finishDate);
        request.writeBytes("&");
        for(String str:resUserID) {
            request.writeBytes("resUserID=" + str);
            request.writeBytes("&");
        }
        request.writeBytes("type=" + type);
        request.writeBytes("&");
        request.writeBytes("name=" + name);
        request.writeBytes("&");
        request.writeBytes("completionForm=" + completionForm);
        request.writeBytes("&");
        request.writeBytes("workID=" + workID);
        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;
        while ((line = br.readLine()) != null) {
            response.append(line);
            response.append("\r");
        }
        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public void setWorkID(String workID) {
        this.workID = workID;
    }

    public void setCompletionForm(String completionForm) {
        this.completionForm = completionForm;
    }

    public void setFinishDate(String finishDate) {
        this.finishDate= finishDate;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResUserID(List resUserID) {
        this.resUserID = resUserID;
    }

    public String getWorkID() {
        return this.workID;
    }

    public String getCompletionForm() {
        return this.completionForm;
    }

    public String getFinishDate() {
        return this.finishDate;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getResUserID() {
        return this.resUserID;
    }
}
