import kz.arta.synergy.api.rest.sample.workflow.*;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by root on 7/2/14.
 */
public class WorkFlowServiceRunner {

    private static String login = "1";
    private static String password = "1";
    private static String address = "http://localhost:8080/Synergy";

    public static void notifyResult(String str) {
        System.out.println();
        System.out.println(str + " result :");
    }

    public static void runAcceptWorkResult() throws Exception {
        WorkFlowServiceAcceptWorkResult service = new WorkFlowServiceAcceptWorkResult(login, password, address);
        service.setResultID("a159b509-fb29-4c8a-9e39-aac5883ccff0");
        service.setWorkID("d0b74a4a-4426-4ec2-b8b9-902eacc2155e");
        notifyResult("acceptWorkResult");
        service.acceptWorkResult();
    }

    public static void runCreateWork() throws Exception {
        WorkFlowServiceCreateWork service = new WorkFlowServiceCreateWork(login, password, address);
        service.setName("some_work");
        service.setStartDate("2014-08-03 09:00:00");
        service.setFinishDate("2014-09-03 09:00:00");
        service.setUserID("1");
        service.setPriority("1");
        notifyResult("createWork");
        service.createWork();
    }

    public static void runAddAttachment() throws Exception {
        WorkFlowServiceAddAttachment service = new WorkFlowServiceAddAttachment(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        service.setAttachmentName("Coke3.png");
        service.setFilePath("/home/acer/Pictures/index.png");
        notifyResult("addAttachment");
        service.addAttachment();
    }

    public static void runAddComment() throws Exception {
        WorkFlowServiceAddComment service = new WorkFlowServiceAddComment(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        service.setCommentID("6180ef85-3840-47b7-a038-6f8a0cf72931");
        service.setCommentText("asd");
        notifyResult("addComment");
        service.addComment();
    }

    public static void runCreateAttachment() throws Exception {
        WorkFlowServiceCreateAttachment service = new WorkFlowServiceCreateAttachment(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        service.setFilePath("/home/acer/Pictures/index3.png");
        service.setAttachmentName("Coke5.png");
        notifyResult("createAttachment");
        service.createAttachment();
    }

    public static void runDeleteAttachment() throws Exception {
        WorkFlowServiceDeleteAttachment service = new WorkFlowServiceDeleteAttachment(login, password, address);
        service.setNodeUUID("da56d776-5143-456f-851e-6d2cb0c57667");
        notifyResult("deleteAttachment");
        service.deleteAttachment();
    }

    public static void runDeleteComment() throws Exception {
        WorkFlowServiceDeleteComment service = new WorkFlowServiceDeleteComment(login, password, address);
        service.setCommentID("6180ef85-3840-47b7-a038-6f8a0cf72931");
        notifyResult("deleteComment");
        service.deleteComment();
    }

    public static void runDeleteWork() throws Exception {
        WorkFlowServiceDeleteWork service = new WorkFlowServiceDeleteWork(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        notifyResult("deleteWork");
        service.deleteWork();
    }

    public static void runFinishProcess() throws Exception {
        WorkFlowServiceFinishProcess service = new WorkFlowServiceFinishProcess(login, password, address);
        service.setWorkID("3a40c7ce-8a6e-48ea-a003-18afb8afb85f");
        service.setAddSignature("0");
        service.setProcInstID("asddfg");
        service.setSignal("got_agree");
        notifyResult("finishProcess");
        service.finishProcess();
    }

    public static void runGetAttachment() throws Exception {
        WorkFlowServiceGetAttachment service = new WorkFlowServiceGetAttachment(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        service.setCount("1");
        service.setGetCounters("false");
        notifyResult("getAttachment");
        service.getAttachment();
    }

    public static void runGetComments() throws Exception {
        WorkFlowServiceGetComments service = new WorkFlowServiceGetComments(login, password, address);
        service.setCount("1");
        service.setGetCounters("true");
        service.setStart("0");
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        notifyResult("getComments");
        service.getComments();
    }

    public static void runGetCounters() throws Exception {
        WorkFlowServiceGetCounters service = new WorkFlowServiceGetCounters(login, password, address);
        notifyResult("getCounters");
        service.getCouners();
    }

    public static void runGetDefaultWorkFields() throws Exception {
        WorkFlowServiceGetDefaultWorkFields service = new WorkFlowServiceGetDefaultWorkFields(login, password, address);
        notifyResult("getDefaultWorkFields");
        service.getDefaultWorkFields();
    }

    public static void runGetExecutionProcess() throws Exception {
        WorkFlowServiceGetExecutionProcess service = new WorkFlowServiceGetExecutionProcess(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        notifyResult("getExecutionProcess");
        service.getExecutionProcess();
    }

    public static void runGetFilters() throws Exception {
        WorkFlowServiceGetFilters service = new WorkFlowServiceGetFilters(login, password, address);
        service.setFilterType("OWN_WORKS");
        service.setParentID(null);
        service.setParentObjectID(null);
        service.setUserID("1");
        notifyResult("getFilters");
        service.getFilters();
    }

    public static void runGetFormForCompletionResult() throws Exception {
        WorkFlowServiceGetFormForCompletionResult service = new WorkFlowServiceGetFormForCompletionResult(login, password, address);
        service.setWorkID("391ae433-d2e7-4c9a-a34a-3f7f182ef8ef");
        service.setFormUUID("562b4ca3-af1d-41d4-b43b-722683f77d31");
        notifyResult("getFormForCompletionResult");
        service.getFormForCompletionResult();
    }

    public static void runGetFullAttachments() throws Exception {
        WorkFlowServiceGetFullAttachments service = new WorkFlowServiceGetFullAttachments(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        notifyResult("getFullAttachment");
        service.getFullAttachments();
    }

    public static void runGetSendWorkInfo() throws Exception {
        WorkFlowServiceGetSendWorkInfo service = new WorkFlowServiceGetSendWorkInfo(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        service.setActionType("153");
        service.setOperationType(null);
        notifyResult("getSendWorkInfo");
        service.getSendWorkInfo();
    }

    public static void runGetSubWorks() throws Exception {
        WorkFlowServiceGetSubWorks service = new WorkFlowServiceGetSubWorks(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        notifyResult("getSubWorks");
        service.getSubWorks();
    }

    public static void runGetWorkActions() throws Exception {
        WorkFlowServiceGetWorkActions service = new WorkFlowServiceGetWorkActions(login, password, address);
        service.setWorkID("391ae433-d2e7-4c9a-a34a-3f7f182ef8ef");
        notifyResult("getWorkActions");
        service.getWorkActions();
    }

    public static void runGetWorkCompletionData() throws Exception {
        WorkFlowServiceGetWorkCompletionData service = new WorkFlowServiceGetWorkCompletionData(login, password, address);
        service.setWorkID("d0b74a4a-4426-4ec2-b8b9-902eacc2155e");
        notifyResult("getWorkCompletionData");
        service.getWorkCompletionData();
    }

    public static void runGetWorkCompletionResult() throws Exception {
        WorkFlowServiceGetWorkCompletionResult service = new WorkFlowServiceGetWorkCompletionResult(login, password, address);
        service.setWorkID("d0b74a4a-4426-4ec2-b8b9-902eacc2155e");
        notifyResult("getWorkCompletionResult");
        service.getWorkCompletionResult();
    }

    public static void runGetWorkDocumentInfo() throws Exception {
        WorkFlowServiceGetWorkDocumentInfo service = new WorkFlowServiceGetWorkDocumentInfo(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        notifyResult("getWorkDocumentInfo");
        service.getWorkDocumentInfo();
    }

    public static void runMarkWorkSeen() throws Exception {
        WorkFlowServiceMarkWorkSeen service = new WorkFlowServiceMarkWorkSeen(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        notifyResult("getWorkDocumentInfo");
        service.markWorkSeen();
    }

    public static void runRejectWorkResult() throws Exception {
        WorkFlowServiceRejectWorkResult service = new WorkFlowServiceRejectWorkResult(login, password, address);
        service.setWorkID("8b3e05bb-9807-40a5-ae22-2d10de33a4be");
        service.setComment("there might be your advert");
        service.setStartDate("2014-07-03 10:00:00");
        service.setFinishDate("2014-09-03 10:10:10");
        service.setProgress("1");
        service.setResultID("2066c299-6638-4171-827b-43908e506407");
        notifyResult("rejectWorkResult");
        service.rejectWorkResult();
    }

    public static void runSaveWork() throws Exception {
        WorkFlowServiceSaveWork service = new WorkFlowServiceSaveWork(login, password, address);
        service.setName("some_work2");
        service.setStartDate("2014-08-03 09:00:00");
        service.setFinishDate("2014-09-03 09:00:00");
        service.setUserID("1");
        service.setPriority("1");
        service.setCompletionFormID("4eb20dc9-e0ca-4a8a-846b-4ea3b9a46150");
        service.setActionID("8719d7e6-12a5-439e-be3c-10d12903a965");
        notifyResult("saveWork");
        service.saveWork();
    }

    public static void runSetWorkProgress() throws Exception {
        WorkFlowServiceSetWorkProgress service = new WorkFlowServiceSetWorkProgress(login, password, address);
        service.setWorkID("3c394847-259b-4981-8e1c-190fedac2f65");
        service.setProgress("50");
        notifyResult("setWorkProgress");
        service.setWorkProgress();
    }

    public static void runSetWorkResult() throws Exception {
        WorkFlowServiceSetWorkResult service = new WorkFlowServiceSetWorkResult(login, password, address);
        service.setWorkID("f7ee563a-9fcd-4f6e-a1f0-96153028f095");
        service.setCompletionForm("COMMENT");
        service.setComment("asfsafas");
        notifyResult("setWorkResult");
        service.setWorkResult();
    }

    public static void runSetWorkState() throws Exception {
        WorkFlowServiceSetWorkState service = new WorkFlowServiceSetWorkState(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        service.setStateID(10);
        notifyResult("setWorkState");
        service.setWorkState();
    }

    public static void runStartRoute() throws Exception {
        List<String> list = new ArrayList<String>();
        list.add("1");
        WorkFlowServiceStartRoute service = new WorkFlowServiceStartRoute(login, password, address);
        service.setWorkID("3c394847-259b-4981-8e1c-190fedac2f65");
        service.setCompletionForm("4eb20dc9-e0ca-4a8a-846b-4ea3b9a46150");
        service.setFinishDate("2014-08-03 09:00:00");
        service.setName("asd");
        service.setResUserID(list);
        service.setType(1);
        notifyResult("startRoute");
        service.startRoute();
    }

    public static void runTransferWork() throws Exception {
        WorkFlowServiceTransferWork service = new WorkFlowServiceTransferWork(login, password, address);
        service.setName("asd");
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        service.setUserID("1");
        notifyResult("transferWork");
        service.transferWork();
    }

    public static void runGetProcessFinishInfo() throws Exception {
        WorkFlowServiceGetProcessFinishInfo service = new WorkFlowServiceGetProcessFinishInfo(login, password, address);
        service.setWorkID("8719d7e6-12a5-439e-be3c-10d12903a965");
        service.getProcessFinishInfo();
    }

    public static void runGetWorks() throws Exception {
        WorkFlowServiceGetWorks service = new WorkFlowServiceGetWorks(login, password, address);
        service.setUserID("1");
        service.setAscSort(true);
        service.setExtShowCompleted(false);
        service.getWorks();
    }

    public static void runGetWorksByID() throws Exception {
        List<String> list = new ArrayList<String>();
        list.add("e2f6d01b-c671-4eea-aefb-b38a89872474");
        list.add("f51fc012-331c-4db4-af8f-4b5886f11377");
        list.add("35b8db05-c0fd-476a-ae05-e6d1dc91f409");
        WorkFlowServiceGetWorksByID service = new WorkFlowServiceGetWorksByID(login, password, address);
        service.setWorkIDList(list);
        service.getWorksByID();
    }

    public static void main(String[] args) throws Exception {
        //runAcceptWorkResult();
        //runCreateWork();
        //+runAddAttachment();
        //+runAddComment();
        //+runCreateAttachment();
        //+runDeleteAttachment();
        //+runDeleteComment();
        //+runDeleteWork();
        //runFinishProcess();
        //+runGetAttachment();
        //+runGetComments();
        //GET METHOD
        //+runGetCounters();
        //+runGetDefaultWorkFields();
        //+runGetExecutionProcess();
        //+runGetFilters();
        //+runGetFormForCompletionResult();
        //+runGetFullAttachments();
        //+runGetSendWorkInfo();
        //+runGetSubWorks();
        //+runGetWorkActions();
        //+runGetWorkCompletionData();
        //+runGetWorkCompletionResult();
        //+runGetWorkDocumentInfo();
        //+runMarkWorkSeen();
        //+runRejectWorkResult();
        //+runSaveWork();
        //+runSetWorkProgress();
        //runSetWorkResult();
        //+runSetWorkState();
        //list
        //+runStartRoute();
        //+runTransferWork();
        //runGetProcessFinishInfo();
        //runGetWorks();
        //runGetWorksByID();
    }
}
