package kz.arta.synergy.api.rest.sample.asforms;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

/**
 *
 * класс демонстрации работы метода getFormData класса APIFormsService
 *
 * Created by root on 7/12/14.
 */
public class APIFormsServiceGetFormDataList {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    //идентификатор данных по форме (может быть передано несколько значений). Например, dataUUID=uuid1&dataUUID=uuid2&dataUUID=uuid3
    private List<String> list;

    public APIFormsServiceGetFormDataList(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void getFormData() throws Exception {
        StringBuffer paramList = new StringBuffer();

        for (String param: list) {
            paramList.append("dataUUID=" + param + "&");
        }

        paramList.deleteCharAt(paramList.length()-1);

        URL url = new URL(address + "/rest/api/asforms/data/get?" + paramList);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                if ("uuid".equals(parser.getText())) {
                    System.out.println();
                }
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public void setList(List<String>list) {
        this.list = list;
    }

    public List<String> getList() {
        return this.list;
    }
}
