package kz.arta.synergy.api.rest.sample.asforms;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;

/**
 *
 * класс демонстрации работы метода search класса APIFormsService
 *
 * Created by root on 7/12/14.
 */
public class APIFormsServiceSearch {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    //идентификатор формы (может быть передано несколько значений)
    private List<String> formUUIDList = null;
    //поисковая строка (может быть передано несколько значений, может отсутствовать)
    private List<String> searchList = null;
    //названия компонентов (может быть передано несколько значений, может отсутствовать)
    private List<String> fieldList = null;
    //название компонента по которому будет осуществлена сортировка (может быть передано несколько значений, может отсутствовать)
    private List<String> sortField = null;
    //тип сравнения (может отсутствовать), может принимать значения:
    private List<String> typeList = null;
    //может принимать значения: or - для объединения наборов условий оператором ИЛИ, and - для объединения наборов условий оператором И.
    private String term = null;
    //направление сортировки, возможные значения: "asc", "desc" (может быть передано несколько значений, может отсутствовать). Любое другое значение или его отсутствие будет интерпретировано как "asc".
    private String sortDir = null;
    //тип сортировки содержимого поля, возможные значения: "string" - сортируется как строка, "decimal" - сортируется как число.
    private String sortType = null;
    //номер записи результатов, начиная с которого будут возвращены записи (отсчет с 0)
    private String startRecord = null;
    // количество результатов, которые надо вернуть
    private String recordCount = null;
    //необходимо ли в результатах возвращать удаленные записи (по-умолчанию true)
    private String showDeleted = null;
    //необходимо передать значение этого параметра false , если осуществляется по данным форм, не входящим в реестр
    private String searchInRegistry = null;
    //если передать этот параметр со значением true, то в результаты поиска так же будут включать идентификаторы документов реестра
    private String getDocIds = null;

    public APIFormsServiceSearch(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void search() throws Exception {
        StringBuffer paramList = new StringBuffer();
        int count = formUUIDList.size();

        for (int i=0; i<count; i++) {
            if (i == 0) {
                if (formUUIDList.get(i) != null) {
                    paramList.append("&formUUID" + "=" + formUUIDList.get(i));
                }
                if (searchList.get(i) != null) {
                    paramList.append("&search" + "=" + URLEncoder.encode(searchList.get(i), "UTF-8"));
                }
                if (fieldList.get(i) != null) {
                    paramList.append("&field" + "=" + URLEncoder.encode(fieldList.get(i), "UTF-8"));
                }
                if (typeList.get(i) != null) {
                    paramList.append("&type" + "=" + typeList.get(i));
                }

                paramList.deleteCharAt(0);
            } else {
                if (formUUIDList.get(i) != null) {
                    paramList.append("&formUUID" + new Integer(i).toString() + "=" + formUUIDList.get(i));
                }
                if (searchList.get(i) != null) {
                    paramList.append("&search" + new Integer(i).toString() + "=" + URLEncoder.encode(searchList.get(i), "UTF-8"));
                }
                if (fieldList.get(i) != null) {
                    paramList.append("&field" + new Integer(i).toString() + "=" + URLEncoder.encode(fieldList.get(i), "UTF-8"));
                }
                if (typeList.get(i) != null) {
                    paramList.append("&type" + new Integer(i).toString() + "=" + typeList.get(i));
                }
            }
        }
            if (term != null) {
                paramList.append("&term=" + term);
            }

            if (sortField != null) {
                paramList.append("&sortField=" + sortField);
            }

            if (sortDir != null) {
                paramList.append("&sortDir=" + sortDir);
            }

            if (sortType != null) {
                paramList.append("&sortType=" + sortType);
            }

            if (startRecord != null) {
                paramList.append("&startRecord" + startRecord);
            }

            if (recordCount != null) {
                paramList.append("&recordCount" + recordCount);
            }

            if (showDeleted != null) {
                paramList.append("&showDeleted" + showDeleted);
            }

            if (searchInRegistry != null) {
                paramList.append("&searchInRegistry=" + searchInRegistry);
            }

            if (getDocIds != null) {
                paramList.append("&getDocIds" + getDocIds);
            }

        URL url = new URL(address + "/rest/api/asforms/search?" + paramList.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        System.out.println(response.toString());
    }

    public void setFormUUIDList(List<String> list) {
        formUUIDList = list;
    }

    public void setSearchList(List<String> list) {
        searchList = list;
    }

    public void setFieldList(List<String> list) {
        fieldList = list;
    }

    public void setTypeList(List<String> list) {
        typeList = list;
    }

    public void setSortField(List<String> list) {
        sortField = list;
    }

    public void setSortDir(String sortDir) {
        this.sortDir = sortDir;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public List<String> getFormUUIDList() {
        return formUUIDList;
    }

    public List<String> getSearchList() {
        return searchList;
    }
    public List<String> getFieldList() {
        return fieldList;
    }
    public List<String> getSortField() {
        return sortField;
    }
    public List<String> getTypeList() {
        return typeList;
    }

    public String getTerm() {
        return term;
    }

    public String getSortDir() {
        return sortDir;
    }

    public String getSortType() {
        return sortType;
    }

    public String getStartRecord() {
        return getStartRecord();
    }

    public String getRecordCount() {
        return recordCount;
    }

    public String getShowDeleted() {
        return showDeleted;
    }

    public String getSearchInRegistry() {
        return searchInRegistry;
    }

    public String getGetDocIds() {
        return getDocIds;
    }
}
