package kz.arta.synergy.api.rest.sample.diary;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by root on 7/31/14.
 */
public class DiaryServiceGetModifiedTasks {
    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** uuid пользователя, чьи задачи необходимо посмотреть*/
    private String userID;
    /* стамп времени
     * http://хост:порт/Synergy/rest/api/diary/tasks/uuid_пользователя?last-modified=2013-01-01%2008:00:00
     * Для описания оорфмата json смотрите документацию метода taskToJson(Task)
     */
    private String lastModified;

    public DiaryServiceGetModifiedTasks(String login, String password, String address) {
        this.address = address;
        this.login = login;
        this.password = password;
        this.encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void getModifiedTasks() throws Exception {
        URL url = new URL(address + "/rest/api/diary/tasks/" + userID + "?last-modified=" + lastModified);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getLastModified() {
        return this.lastModified;
    }
}
