package kz.arta.synergy.api.rest.sample.dictionary;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрирует работу метода getDictionaryValues класса DictionaryService
 *
 *
 * Справочник - набор записей, где каждая запись представлена некоторым количеством столбцов.
 * Каждый справочник имеет свой код, который и будет параметром (dictionaryCode), передаваемым в API.
 * Каждый столбец характеризуется кодом, именем, комментарием, свойством наличи перевода (подронее см. в руководсте методолога)
 *
 *
 * Допустим,  у нас есть справочник товаров продовольственного магазина со столбцами:
 *
 * +-------+---------------------+-------------------+--------------+
 * |  Код  |  Имя                |  Комментарий      |  Переводить  |
 * +-------+---------------------+-------------------+--------------+
 * |  id   | Идентификатор       |                   |              |
 * +-------+---------------------+-------------------+--------------+
 * | value | Значение            |                   |     да       |
 * +-------+---------------------+-------------------+--------------+
 * | date  | Дата                | Дата изготовления |              |
 * +-------+---------------------+-------------------+--------------+
 *
 * В котором содержатся значения:
 *
 * +-----------------+-------------+------------+
 * |  Идентификатор  |  Значение   | Дата       |
 * +-----------------+-------------+------------+
 * |  1              |   хлеб      | 14-07-14   |
 * +-----------------+-------------+------------+
 * |  2              |   молоко    | 14-07-14   |
 * +-----------------+-------------+------------+
 *
 *
 *
 * Результат работы метода getDictionaryValues
 *
 * {"dictionary_code" : "food_good",
 * "dictionaryID" : "идентификатор справочника",
 *
 * "columns" : [
 * {
 *     "columnID" : "aaaa-aaaa-aaaa-aaaa",
 *     "code" : "id"
 * },
 * {
 *     "columnID" : "bbbb-bbbb-bbbb-bbbb",
 *     "code" : "value"
 * },
 * {
 *     "columnID" : "cccc-cccc-cccc-cccc",
 *     "code" : "date"
 * }
 * ],
 *
 * "items" : [
 *      {
 *          "itemID" : "1111-1111-1111-1111",
 *          "values" : [
 *              {
 *                  "value" : "1",
 *                  "columnID" : "aaaa-aaaa-aaaa-aaaa",
 *                  "translation" : ""
 *              },
 *              {
 *                  "value" : "хлеб",
 *                  "columnID" : "bbbb-bbbb-bbbb-bbbb",
 *                  "translation" : "bread"
 *              },
 *              {
 *                  "value" : "10-07-2014",
 *                  "columnID" : "cccc-cccc-cccc-cccc",
 *                  "translation" : ""
 *              }
 *          ]
 *      },
 *      {
 *          "itemID" : "2222-2222-2222-2222",
 *          "values" : [
 *              {
 *                  "value" : "2",
 *                  "columnID" : "aaaa-aaaa-aaaa-aaaa",
 *                  "translation" : ""
 *              },
 *              {
 *                  "value" : "молоко",
 *                  "columnID" : "bbbb-bbbb-bbbb-bbbb",
 *                  "translation" : "milk"
 *              },
 *              {
 *                  "value" : "10-07-2014",
 *                  "columnID" : "cccc-cccc-cccc-cccc",
 *                  "translation" : ""
 *              }
 *          ]
 *      }
 * ]
 * }
 *
 * json данные спровочника в таблице :
 *
 *          +------+---------+-------------+
 *          | id   | value   | date        |
 *          +------+---------+-------------+
 *          | 1    |  хлеб   | 10-07-2014  |
 *          +------+---------+-------------+
 *          | 2    |  молоко | 10-07-2014  |
 *          +------+---------+-------------+
 *
 * Created by root on 7/16/15.
 *
 */
public class DictionaryServiceGetDictionaryValues {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    /** Переменная URL Arta Synergy. */
    private String address;
    private String encoded;
    /** код справочника */
    private String dictionaryCode;

    public DictionaryServiceGetDictionaryValues(String address, String login, String password) {
        this.address = address;
        this.login = login;
        this.password = password;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void getDictionaryValues() throws Exception {
        URL url = new URL(address + "/rest/api/dictionary/get_by_code?dictionaryCode=" + dictionaryCode+"&locale=kz");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        System.out.println(response.toString());
        is.close();
        br.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser =factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null){
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public void setDictionaryCode(String dictionaryCode) {
        this.dictionaryCode = dictionaryCode;
    }

    public String getDictionaryCode() {
        return this.dictionaryCode;
    }
}
