package kz.arta.synergy.api.rest.sample.dictionary;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Изменяет запись справочника
 *
 * Created by user1 on 03.09.14.
 */
public class DictionaryServiceModifyRecord {

    private String login;
    private String password;
    private String address;
    /*
    "Content-type" запроса должен быть "application/json; charset=utf-8" и в теле запроса JSON в следующем формате

 {
 "dictCode": "apitest",
 "itemID": "195af529-35ee-4bd7-a2b8-bcc04c731283",
 "columns": [
  {
      "code": "number",
      "value": "42",
      "valueKZ": null,
      "valueRU": null,
      "valueEN": null
  },
  {
      "code": "field_name",
      "value": "Поле с переводами",
      "valueKZ": "казахский",
      "valueRU": "русский",
      "valueEN": "английский"
  },
  {
      "code": "field_desc",
      "value": "Тест переводов",
      "valueKZ": null,
      "valueRU": null,
      "valueEN": null
  }
 ]
 }


, где
dictCode - код справочника
itemID - идентификатор редактируемой записи справочника
columns - список столбцов справочника, где

    code - код столбца справочника

    value - значение столбца справочника

    valueKZ, valueRU, valueEN - локализованные значения столбца справочника
     */
    private String requestData;

    public DictionaryServiceModifyRecord(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
    }

    public void modifyRecord() throws Exception {
        URL url = new URL(address + "/rest/api/dictionary/record/edit");
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Accept", "application/json; charset=utf-8");
        conn.setRequestProperty("Content-type", "application/json; charset=utf-8");
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Cache-Control", "no-cache");
        String encoded = Base64.encode((login + ":" + password).getBytes());
        conn.setRequestProperty("Authorization", "Basic " + encoded);

        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(conn.getOutputStream());

        request.write(requestData.getBytes());

        request.flush();
        request.close();

        InputStream is = conn.getInputStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        String line;
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        rd.close();
        System.out.println(response.toString());

    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }
}
