package kz.arta.synergy.api.rest.sample.filecabinet;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * класс демонстрации работы метода getDepartment класса DepartmentsService
 *
 * Created by root on 7/17/15.
 */
public class DepartmentsServiceGetDepartmentsAsList {
    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    private Integer partNumber;
    private Integer countInPart;

    public DepartmentsServiceGetDepartmentsAsList(String address, String login, String password) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void getDepartmentsAsList() throws Exception {

        StringBuffer paramList = new StringBuffer();
        if (partNumber != null) {
            paramList.append("&partNumber=" + partNumber);
        }

        if (countInPart != null) {
            paramList.append("&countInPart=" + countInPart);
        }

        if (paramList.length() != 0) {
            paramList.deleteCharAt(0);
            paramList.insert(0, '?');
        }

        URL url = new URL(address + "/rest/api/departments/list" + paramList.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                if ("uuid".equals(parser.getText())) {
                    System.out.println();
                }
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public Integer getPartNumber() {
        return partNumber;
    }

    public void setPartNumber(Integer partNumber) {
        this.partNumber = partNumber;
    }

    public Integer getCountInPart() {
        return countInPart;
    }

    public void setCountInPart(Integer countInPart) {
        this.countInPart = countInPart;
    }
}
