package kz.arta.synergy.api.rest.sample.filecabinet;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;

/**
 *
 * класс демонстрации работы метода appointAssistant класса PositionService
 *
 * Created by root on 7/17/15.
 */
public class PositionsServiceAppointAssistant {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** название должности на русском языке (FormParam)*/
    private String nameRU;
    /** название должности на русском языке (FormParam)*/
    private String nameKZ;
    /** название должности на русском языке (FormParam)*/
    private String nameEN;
    /** порядковый номер для сортировки (по умолчанию 0) (FormParam)*/
    private int number = 0;
    /**  UUID родительского департамента (FormParam)*/
    private String departmentID;
    /** UUID-ы дочерних подразделений (FormParam)*/
    private List<String> childDepartmentID = null;
    /** UUID пользователя которого надо назначить на должность (FormParam)*/
    private String userID;

    public PositionsServiceAppointAssistant(String address, String login, String password) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void appointAssistant() throws Exception {

        URL url = new URL(address + "/rest/api/positions/assistant/appoint");
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Accept", "application/json; charset=utf-8");
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Cache-Control", "no-cache");
        conn.setRequestProperty("Authorization", "Basic "+encoded);

        conn.setUseCaches (false);
        conn.setDoInput(true);
        conn.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(conn.getOutputStream());
        request.writeBytes("nameRu=" + URLEncoder.encode(nameRU, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("nameKz=" + URLEncoder.encode(nameKZ, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("nameEn=" + URLEncoder.encode(nameEN, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("number=" + number);
        request.writeBytes("&");
        request.writeBytes("departmentID=" + departmentID);
        if (childDepartmentID != null) {
            for (String str : childDepartmentID) {
                request.writeBytes("&");
                request.writeBytes("childDepartmentID=" + str);
            }
        }
        request.writeBytes("&");
        request.writeBytes("userID=" + userID);
        request.flush();
        request.close();

        InputStream is = conn.getInputStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        String line;
        StringBuffer response = new StringBuffer();
        while((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        rd.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }

            }
        }
    }

    public String getUserID() {
        return userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public List<String> getChildDepartmentID() {
        return childDepartmentID;
    }

    public void setChildDepartmentID(List<String> childDepartmentID) {
        this.childDepartmentID = childDepartmentID;
    }

    public String getDepartmentID() {
        return departmentID;
    }

    public void setDepartmentID(String departmentID) {
        this.departmentID = departmentID;
    }

    public int getNumber() {
        return number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getNameEN() {
        return nameEN;
    }

    public void setNameEN(String nameEN) {
        this.nameEN = nameEN;
    }

    public String getNameKZ() {
        return nameKZ;
    }

    public void setNameKZ(String nameKZ) {
        this.nameKZ = nameKZ;
    }

    public String getNameRU() {
        return nameRU;
    }

    public void setNameRU(String nameRU) {
        this.nameRU = nameRU;
    }
}
