package kz.arta.synergy.api.rest.sample.filecabinet.auth;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by user1 on 03.09.14.
 */
public class ListWorksWithAuthKeyExample {

    private String address;
    private String key;

    public void getWorks() throws Exception {
        URL url = new URL(address + "/rest/api/workflow/works/list/");
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json; charset=utf-8");

        String encoded = Base64.encode(("$key:" + key).getBytes());
        conn.setRequestProperty("Authorization", "Basic "+encoded);

        String output;
        StringBuffer contactsInfo = new StringBuffer();

        BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));

        while ((output = br.readLine()) != null) {
            contactsInfo.append(output);
        }

        conn.disconnect();
        System.out.println(contactsInfo.toString());

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(contactsInfo.toString());
        JsonToken token = null;


        while ((token = parser.nextToken()) != null){
            if (token == JsonToken.FIELD_NAME){
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING){
                    System.out.print(parser.getText());
                }

            }
        }
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}
