package kz.arta.synergy.api.rest.sample.map;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by root on 8/1/14.
 */
public class MapServiceSave {
    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;

    /** Название карты*/
    private String name;
    /** true - доступна всем пользователям, иначе - только тем, кому даны права*/
    private boolean isPublic = false;
    /** идентификатор родительско карты (значение по-умолчанию корневой элемент "Стратегия")*/
    private String parentID = null;
    /** ширина карты (значение по-умолчанию MapConstants.DEFAULT_WIDTH)*/
    private String width = null;
    /** высота карты (значение по-умолчанию MapConstants.DEFAULT_HEIGHT)*/
    private String height = null;
    /** идентификатор карты */
    private String mapID = null;

    public MapServiceSave(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        this.encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void save() throws Exception {

        URL url = new URL(address + "/rest/api/maps/save");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());

        request.writeBytes("name=" + name);
        request.writeBytes("&");
        request.writeBytes("isPublic=" + isPublic);
        request.writeBytes("&");
        request.writeBytes("mapID=" + mapID);

        if (parentID != null) {
            request.writeBytes("&");
            request.writeBytes("parentID=" + parentID);
        }

        if (width != null) {
            request.writeBytes("&");
            request.writeBytes("width=" + width);
        }

        if (height != null) {
            request.writeBytes("&");
            request.writeBytes("height=" + height);
        }

        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        System.out.println(response.toString());

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPublic() {
        return isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public String getParentID() {
        return parentID;
    }

    public void setParentID(String parentID) {
        this.parentID = parentID;
    }

    public String getWidth() {
        return width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getMapID() {
        return mapID;
    }

    public void setMapID(String mapID) {
        this.mapID = mapID;
    }
}
