package kz.arta.synergy.api.rest.sample.map;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by root on 7/31/14.
 */
public class PointersServiceCreatePointer {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** идентификатор показателя, необходимо передавать для обновления существующего показателя.
     * Для создания нового - передавать параметр не нужно. */
    private String pointerID = null;
    /** тип показателя, значение должно быть 2, 4, 1*/
    private String type = null;
    /** название показателя */
    private String name = null;
    /** код показателя */
    private String code = null;
    /** единица измерения значений показателя */
    private String measure = null;
    /** Тип обновления значений показателя. Может принимать значения:

     1 - ежедневно
     2 - по дням недели
     3 - по дням месяца
     4 - ежеквартально

     */
    private String updateType = null;
    /** значение (одно или несколько) данного параметра необходимо передать, только если update_type=2
     * или update_type=3. Для update_type=2 - это должны быть номера дней недели от 1 до 7, для дней месяца - номера дней месяца от 1 до 31 */
    private String updateDays = null;
    /** идентификатор пользователя, ответственного за ввод значения показателя */
    private String resUserID = null;
    /** значение показателя по-умолчанию */
    private String defaultValue = null;
    /** код справочника (необходимо в том случае если значения показателя должны выбираться из справочника, а не вводиться вручную) */
    private String dictCode = null;
    /** минимальное возможное значение показателя (число либо код другого показателя) */
    private String minValue = null;
    /** максимальное возможное значение показателя (число либо код другого показателя) */
    private String maxValue = null;
    /** формула расчета показателя */
    private String formula = null;

    public PointersServiceCreatePointer(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        this.encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void createPointer() throws Exception {

        URL url = new URL(address + "/rest/api/pointers/save");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");//GET
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());

        request.writeBytes("type=" + type);

        request.writeBytes("&");
        request.writeBytes("name=" + name);
        request.writeBytes("&");
        request.writeBytes("measure=" + measure);
        /*
        if (pointerID != null) {
            request.writeBytes("&");
            request.writeBytes("pointerID=" + pointerID);
        }

        if (code != null) {
            request.writeBytes("&");
            request.writeBytes("code=" + code);
        }

        if (updateType != null) {
            request.writeBytes("&");
            request.writeBytes("update_type=" + updateType);
        }

        if (updateDays != null) {
            request.writeBytes("&");
            request.writeBytes("update_days=" + updateDays);
        }

        if (resUserID != null) {
            request.writeBytes("&");
            request.writeBytes("resUserID=" + resUserID);
        }

        if (defaultValue != null) {
            request.writeBytes("&");
            request.writeBytes("default_value=" + defaultValue);
        }

        if (dictCode != null) {
            request.writeBytes("&");
            request.writeBytes("dictCode=" + dictCode);
        }

        if (minValue != null) {
            request.writeBytes("&");
            request.writeBytes("min_value=" + minValue);
        }

        if (maxValue != null) {
            request.writeBytes("&");
            request.writeBytes("max_value=" + maxValue);
        }

        if (formula != null) {
            request.writeBytes("&");
            request.writeBytes("formula=" + formula);
        }*/

        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        System.out.println(response.toString());

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public String getPointerID() {
        return pointerID;
    }

    public void setPointerID(String pointerID) {
        this.pointerID = pointerID;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMeasure() {
        return measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public String getUpdateType() {
        return updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public String getUpdateDays() {
        return updateDays;
    }

    public void setUpdateDays(String updateDays) {
        this.updateDays = updateDays;
    }

    public String getResUserID() {
        return resUserID;
    }

    public void setResUserID(String resUserID) {
        this.resUserID = resUserID;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDictCode() {
        return dictCode;
    }

    public void setDictCode(String dictCode) {
        this.dictCode = dictCode;
    }

    public String getMinValue() {
        return minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public String getMaxValue() {
        return maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public String getFormula() {
        return formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }
}
