package kz.arta.synergy.api.rest.sample.mobile;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Метод добавляет в систему token устройства для авторизовавшегося пользователя
 *
 * Created by user1 on 03.09.14.
 */

public class MobileUtilsServiceAddDeviceToken {

    private String login;
    private String password;
    private String address;
    // идентификатор устройства
    private String token;
    // тип устройства
    private String type;

    public MobileUtilsServiceAddDeviceToken(String login, String password, String address) {
        this.address = address;
        this.login = login;
        this.password = password;
    }

    public void addDeviceToken() throws Exception {
        URL url = new URL(address + "/rest/api/mobile/utils/add_token?token=" + token + "&type=" + type);
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json; charset=utf-8");
        String encoded = Base64.encode((login + ":" + password).getBytes());
        conn.setRequestProperty("Authorization", "Basic "+encoded);

        String output;
        StringBuffer contactsInfo = new StringBuffer();

        BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));

        while ((output = br.readLine()) != null) {
            contactsInfo.append(output);
        }

        conn.disconnect();
        System.out.println(contactsInfo.toString());

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(contactsInfo.toString());
        JsonToken token = null;


        while ((token = parser.nextToken()) != null){
            if (token == JsonToken.FIELD_NAME){
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING){
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}
