package kz.arta.synergy.api.rest.sample.person;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * класс демонстрации работы метода getUser класса PersonService
 *
 * Created by root on 7/18/15.
 */
public class PersonServiceGetUser {
    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /**  если данный параметр true, то метод вернет так же список групп в которых состоит авторизованный пользовател*/
    private boolean getGroups = false;
    private String sso_hash;

    public PersonServiceGetUser(String address, String login, String password, String sso_hash) {
        this.login = login;
        this.password = password;
        this.address = address;
        this.sso_hash = sso_hash;
        encoded = Base64.encode(("$session:" + sso_hash).getBytes());
    }

    public void getUser() throws Exception {
        URL url = new URL(address + "/rest/api/person/auth?getGroups=" + getGroups);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public boolean IsGetGroups() {
        return getGroups;
    }

    public void setGetGroups(boolean getGroups) {
        this.getGroups = getGroups;
    }
}
