package kz.arta.synergy.api.rest.sample.registry;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрации работы метода deleteRegistryDocument класса RegistryService
 *
 * Created by root on 7/12/14.
 */
public class RegistryServiceDeleteRegistryDocument {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** идентификатор документа (необязательный)*/
    private String documentID = null;
    /** идентификатор файла по форме (необязательный)*/
    private String dataUUID = null;

    public RegistryServiceDeleteRegistryDocument(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void deleteRegistryDocument() throws Exception {
        StringBuffer paramList = new StringBuffer();
        if (documentID != null) {
            paramList.append("documentID=" + documentID);
        }

        if (dataUUID != null) {
            if (paramList.length() != 0) {
                paramList.append("&");
            }
            paramList.append("dataUUID=" + dataUUID);
        }
        URL url = new URL(address + "/rest/api/registry/delete_doc?" + paramList.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }
    public void setDocumentID(String documentID) {
        this.documentID = documentID;
    }

    public void setDataUUID(String dataUUID) {
        this.dataUUID = dataUUID;
    }

    public String getDocumentID() {
        return this.documentID;
    }

    public String getDataUUID() {
        return this.dataUUID;
    }
}
