package kz.arta.synergy.api.rest.sample.storage;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

/**
 * Класс демонстрации работы метода createWork класса WorkFlowService
 *
 * Created by root on 7/2/14.
 */
public class StorageServiceSearch {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** строка, которая должна содержаться в искомых файлах*/
    private String contains;
    /** строка, которая не должна содержаться в искомых файлах*/
    private String notContains;
    /** идентификатор классификатора, которому должны принадлежать искомые файлы. Значение данного параметра может быть передано несколько раз*/
    private List<Integer> categoryID;
    /** определяет тип искомых файлов. Может быть передано значение одной из констант*/
    private String aiType;
    /** идентификатор папки хранилища, в которой необходимо осуществить поиск*/
    private String folderID;
    /** начало периода последнего изменения в формате yyyy-MM-dd*/
    private String modifiedFrom;
    /** завершение периода последнего изменения в формате yyyy-MM-dd*/
    private String modifiedTo;
    /** определяет размер искомого файла*/
    private int sizeType;
    /** параметр определяет тип сортировки файлов*/
    private int sortType;
    /** отображать ли в результатах поиска неопубликованные файлы*/
    private boolean includeUnpublished;
    /** отображать ли в результатах поиска файлы, срок действия которых истек*/
    private boolean includeExpired;
    /** осуществлять ли поиск в папках документов, проектов*/
    private boolean includeCompanions;
    /** номер первой записи для возвращаемых результатов выборки*/
    private int firstResult;
    /** количество записей, которые должны быть возвращены*/
    private int maxResult;

    public String getContains() {
        return contains;
    }

    public void setContains(String contains) {
        this.contains = contains;
    }

    public String getNotContains() {
        return notContains;
    }

    public void setNotContains(String notContains) {
        this.notContains = notContains;
    }

    public List<Integer> getCategoryID() {
        return categoryID;
    }

    public void setCategoryID(List<Integer> categoryID) {
        this.categoryID = categoryID;
    }

    public String getAiType() {
        return aiType;
    }

    public void setAiType(String aiType) {
        this.aiType = aiType;
    }

    public String getFolderID() {
        return folderID;
    }

    public void setFolderID(String folderID) {
        this.folderID = folderID;
    }

    public String getModifiedFrom() {
        return modifiedFrom;
    }

    public void setModifiedFrom(String modifiedFrom) {
        this.modifiedFrom = modifiedFrom;
    }

    public String getModifiedTo() {
        return modifiedTo;
    }

    public void setModifiedTo(String modifiedTo) {
        this.modifiedTo = modifiedTo;
    }

    public int getSizeType() {
        return sizeType;
    }

    public void setSizeType(int sizeType) {
        this.sizeType = sizeType;
    }

    public int getSortType() {
        return sortType;
    }

    public void setSortType(int sortType) {
        this.sortType = sortType;
    }

    public boolean isIncludeUnpublished() {
        return includeUnpublished;
    }

    public void setIncludeUnpublished(boolean includeUnpublished) {
        this.includeUnpublished = includeUnpublished;
    }

    public boolean isIncludeExpired() {
        return includeExpired;
    }

    public void setIncludeExpired(boolean includeExpired) {
        this.includeExpired = includeExpired;
    }

    public boolean isIncludeCompanions() {
        return includeCompanions;
    }

    public void setIncludeCompanions(boolean includeCompanions) {
        this.includeCompanions = includeCompanions;
    }

    public int getFirstResult() {
        return firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public int getMaxResult() {
        return maxResult;
    }

    public void setMaxResult(int maxResult) {
        this.maxResult = maxResult;
    }

    public StorageServiceSearch(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void search() throws Exception {

        URL url = new URL(address + "/rest/api/storage/search");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Cache-Control", "no-cache");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestMethod("POST");

        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("contains=" + contains);
        request.writeBytes("&");
        request.writeBytes("notContains=" + notContains);
        request.writeBytes("&");
        request.writeBytes("includeUnpublished=" + includeUnpublished);
        request.writeBytes("&");
        request.writeBytes("includeExpired=" + includeExpired);
        request.writeBytes("&");
        request.writeBytes("includeCompanions=" + includeCompanions);

        for(Integer id: categoryID) {
            request.writeBytes("&");
            request.writeBytes("categoryID=" + id);
        }

        if (aiType != null) {
            request.writeBytes("&");
            request.writeBytes("aiType=" + aiType);
        }

        if (folderID != null) {
            request.writeBytes("&");
            request.writeBytes("folderID=" + folderID);
        }

        if (modifiedFrom != null) {
            request.writeBytes("&");
            request.writeBytes("modifiedForm=" + modifiedFrom);
        }

        if (modifiedTo != null) {
            request.writeBytes("&");
            request.writeBytes("modifiedTo=" + modifiedTo);
        }

        if (sizeType != -1) {
            request.writeBytes("&");
            request.writeBytes("sizeTyp=" + sizeType);
        }

        if (sortType != -1) {
            request.writeBytes("&");
            request.writeBytes("sortType=" + sortType);
        }

        if (firstResult != -1) {
            request.writeBytes("&");
            request.writeBytes("firstResult=" + firstResult);
        }

        if (maxResult != -1) {
            request.writeBytes("&");
            request.writeBytes("maxResult=" + maxResult);
        }

        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
            response.append("\r");
        }

        br.close();
        is.close();
        System.out.println(response.toString());
    }
}
