package kz.arta.synergy.api.rest.sample.storage;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 *
 *
 * @see kz.arta.synergy.api.rest.sample.workflow.WorkFlowServiceCreateAttachment
 */

public class StorageServiceUploadPart {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** */
    private String file;

    public StorageServiceUploadPart(String address, String login, String password) {
        this.address = address;
        this.login = login;
        this.password = password;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void uploadPart() throws Exception {
        String boundary = "go, spidey, go!";
        String clrf = "\r\n";

        URL url = new URL(address + "/rest/api/storage/upload_part");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        FileInputStream fis = new FileInputStream(file);
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("--" + boundary + clrf);
        request.writeBytes("Content-Disposition: form-data; name=\"body\"" + clrf);
        request.writeBytes(clrf);
        request.write(Base64.encode(bytes).getBytes());
        request.writeBytes(clrf);
        request.writeBytes("--" + boundary + "--" + clrf);
        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return file;
    }
}
