package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

/**
 * Класс демонстрирует работу метода addAttachment класса WorkFlowService
 *
 * Created by root on 7/2/14.
 */
public class WorkFlowServiceAddAttachment {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    private String workID = "";
    /** Путь к прикрепляемому файлу. */
    private String filePath = "";
    /** Название прикрепляемого файла. */
    private String attachmentName = "";

    public WorkFlowServiceAddAttachment(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void addAttachment() throws Exception {

        FileInputStream fis = new FileInputStream(filePath);
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);

        String boundary = "qweasdzxczxcasdqwe";
        String crlf = "\r\n";
        String twoHypens = "--";

        URL url = new URL(address + "/rest/api/workflow/work/" + workID + "/attachment/add" +
                "?path=ase:attachmentContainer");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Cache-Control", "no-cache");
        connection.setRequestProperty("Authorization", "Basic " + encoded);

        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes(twoHypens + boundary + crlf);
        request.writeBytes("Content-Disposition: form-data; name=\"body\";filename=\""
                + URLEncoder.encode(attachmentName, "utf-8") + "\"" + crlf);
        request.writeBytes(crlf);
        request.write(Base64.encode(bytes).getBytes());
        request.writeBytes(crlf);
        request.writeBytes(twoHypens + boundary + twoHypens + crlf);

        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;
        while ((line = br.readLine()) != null) {
            response.append(line);
            response.append("\r");
        }
        br.close();
        is.close();
        System.out.println(response.toString());
    }

    public void setWorkID(String workID) {
        this.workID = workID;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public String getWorkID() {
        return this.workID;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }
}
