package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.JsonParser;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

/**
 * Класс демонстрации работы метода addComment класса WorkFlowService
 *
 * Created by root on 7/2/14.
 */
public class WorkFlowServiceAddComment {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    private String workID;
    /** uuid комментария, для добавления нового комментария - не передавать. */
    private String commentID;
    /** текст комментария (передается как параметр формы). */
    private String commentText;

    public WorkFlowServiceAddComment(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void addComment() throws Exception {

        URL url = new URL(address + "/rest/api/workflow/work/" + workID + "/comments/save");
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Accept", "application/json; charset=utf-8");
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Cache-Control", "no-cache");
        conn.setRequestProperty("Authorization", "Basic "+encoded);

        conn.setUseCaches (false);
        conn.setDoInput(true);
        conn.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(conn.getOutputStream());
        request.writeBytes("comment=" + URLEncoder.encode(commentText, "utf-8"));
        request.write(("&commentID=" + commentID).getBytes());
        request.flush();
        request.close ();


        InputStream is = conn.getInputStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        String line;
        StringBuffer response = new StringBuffer();
        while((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        rd.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                String fieldName = parser.getText();
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }

            }
        }
    }

    public void setWorkID(String workID) {
        this.workID = workID;
    }

    public void setCommentID(String commentID) {
        this.commentID = commentID;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public String getWorkID() {
        return this.workID;
    }

    public String getCommentID() {
        return this.commentID;
    }

    public String getCommentText() {
        return this.commentText;
    }
}
