package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрации работы метода createAttachment класса WorkFlowService
 *
 * Created by root on 7/2/14.
 */

public class WorkFlowServiceDeleteAttachment {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** идентификатор файла который надо удалить. */
    private String nodeUUID;

    public WorkFlowServiceDeleteAttachment(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void deleteAttachment() throws Exception {

        URL url = new URL(address + "/rest/api/workflow/work/remove_file?nodeUUID=" + nodeUUID);
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json; charset=utf-8");
        conn.setRequestProperty("Authorization", "Basic "+encoded);

        String output;
        StringBuffer contactsInfo = new StringBuffer();

        BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));

        while ((output = br.readLine()) != null) {
            contactsInfo.append(output);
        }

        conn.disconnect();
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(contactsInfo.toString());
        JsonToken token = null;


        while ((token = parser.nextToken()) != null){
            if (token == JsonToken.FIELD_NAME){
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING){
                    System.out.print(parser.getText());
                }

            }
        }
    }

    public void setNodeUUID(String nodeUUID) {
        this.nodeUUID = nodeUUID;
    }

    public String getNodeUUID() {
        return nodeUUID;
    }
}
