package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрации работы метода finishProcess класса WorkFlowService
 *
 * Created by root on 7/3/14.
 */
public class WorkFlowServiceFinishProcess {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** Идентификатор процесса (родительского для процесса работы, поле procInstID работы).*/
    private String procInstID;
    /** Название сигнала. */
    private String signal;
    /** base-64 закодированные подписываемые данные (получаются в методе getProcessFinishInfo/process_info). */
    private String rawdata;
    /** Необходимо ли добавить подпись. */
    private String addSignature;
    /** Необходим для извлечения rawdata. */
    private String workID;

    public WorkFlowServiceFinishProcess(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void finishProcess() throws Exception {

        // Получаем rawdata
        {
            URL url = new URL(address + "/rest/api/workflow/process_info?workID=" + workID);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json; charset=utf-8");
            connection.setRequestProperty("Authorization", "Basic " + encoded);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(true);

            InputStream is = connection.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuffer response = new StringBuffer();
            String line;

            while ((line = br.readLine()) != null) {
                response.append(line);
            }

            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createJsonParser(response.toString());
            JsonToken token = null;
            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME && "rawdata".equals(parser.getText())) {
                    token = parser.nextToken();
                    if (token == JsonToken.VALUE_STRING) {
                        rawdata = parser.getText();
                        break;
                    }
                }
            }

            br.close();
            is.close();
        }

        URL url = new URL(address + "/rest/api/workflow/finish_process");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Cache-Control", "no-chache");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("procInstID=" + procInstID);
        request.writeBytes("&");
        request.writeBytes("signal=" + signal);
        request.writeBytes("&");
        request.writeBytes("rawdata=" + Base64.encode(rawdata.getBytes()));
        request.writeBytes("&");
        request.writeBytes("addSignature=" + addSignature);
        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
            response.append("\r");
        }

        System.out.println(response.toString());
        is.close();
        br.close();
    }

    public void setProcInstID(String procInstID) {
        this.procInstID = procInstID;
    }

    public void setSignal(String signal) {
        this.signal = signal;
    }

    public void setAddSignature(String addSignature) {
        this.addSignature = addSignature;
    }

    public void setWorkID(String workID) {
        this.workID = workID;
    }

    public String getProcInstID() {
        return this.procInstID;
    }

    public String getSignal() {
        return this.signal;
    }

    public String getAddSignature() {
        return this.addSignature;
    }

    public String getWorkID() {
        return this.workID;
    }
}
