package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрирующий работу метода getDefaultWorkFields класса WorkFlowService
 *
 * Created by root on 7/3/14.
 */
public class WorkFlowServiceGetDefaultWorkFields {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;

    public WorkFlowServiceGetDefaultWorkFields(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void getDefaultWorkFields() throws Exception {

        URL url = new URL(address + "/rest/api/workflow/work/create_defaults");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while((line = br.readLine()) != null) {
            response.append(line);
            response.append("\r");
        }

        System.out.println(response.toString());
        br.close();
        is.close();
    }
}
