package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;


import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрирующий работу метода getFilters класса WorkFlowService
 *
 * Created by root on 7/3/14.
 */
public class WorkFlowServiceGetFilters {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;

    /** Тип фильтра. */
    private String filterType;
    /** UUID родительского фильтра. */
    private String parentID;
    /** UUID объекта родительского фильтра. */
    private String parentObjectID;
    /** UUID пользователя. */
    private String userID;

    public WorkFlowServiceGetFilters(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void getFilters() throws Exception {

        URL url = new URL(address + "/rest/api/workflow/works/filters/" + userID + "?filterType="
                + filterType + "&parentID=" + parentID + "&parentObjectID=" + parentObjectID
                + "&userID=" + userID);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
            response.append("\r");
        }

        System.out.println(response.toString());
        br.close();
        is.close();
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public void setParentID(String parentID) {
        this.parentID = parentID;
    }

    public void setParentObjectID(String parentObjectID) {
        this.parentObjectID = parentObjectID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public String getParentID() {
        return this.parentID;
    }

    public String getParentObjectID() {
        return this.parentObjectID;
    }

    public String getUserID() {
        return this.userID = userID;
    }
}
