package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрирующий работу метода getWorks класса WorkFlowService
 *
 * Created by root on 7/13/14.
 */
public class WorkFlowServiceGetWorks {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;

    private String userID;
    private String filterType;
    private String filterID;
    private String objectID;
    private String sortColumn;
    private boolean isAscSort = false;
    private boolean hasExtSearchParams = false;
    private int periodType;
    private String extStartDate;
    private String extFinishDate;
    private boolean extShowCompleted = false;
    private boolean extShowDeleted = false;
    private int extDateSearchType = -1;
    private String locale;

    public WorkFlowServiceGetWorks(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void getWorks() throws Exception {
        StringBuffer paramList = new StringBuffer();

        if (filterType != null) {
            paramList.append("&filterType=" + filterType);
        }

        if (filterID != null) {
            paramList.append("&filterID=" + filterID);
        }

        if (objectID != null) {
            paramList.append("&objectID=" + objectID);
        }

        if (sortColumn != null) {
            paramList.append("&sortColumn=" + sortColumn);
        }

        if (extStartDate != null) {
            paramList.append("&extStartDate=" + extStartDate);
        }

        if (extFinishDate != null) {
            paramList.append("&extFinishDate=" + extFinishDate);
        }

        paramList.append("&extShowCompleted=" + extShowCompleted);


        paramList.append("&extShowDeleted=" + extShowDeleted);

        if (extDateSearchType != -1) {
            paramList.append("&extDateSearchType=" + extDateSearchType);
        }

        paramList.append("&isAscSort=" + isAscSort);

        if (hasExtSearchParams != false) {
            paramList.append("&hasExtSearchParams=" + hasExtSearchParams);
        }

        paramList.deleteCharAt(0);

        URL url = new URL(address + "/rest/api/workflow/works/list/" + userID + "?" + paramList);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setUseCaches(true);
        connection.setDoInput(true);

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public int getExtDateSearchType() {
        return extDateSearchType;
    }

    public void setExtDateSearchType(int extDateSearchType) {
        this.extDateSearchType = extDateSearchType;
    }

    public boolean isExtShowDeleted() {
        return extShowDeleted;
    }

    public void setExtShowDeleted(boolean extShowDeleted) {
        this.extShowDeleted = extShowDeleted;
    }

    public boolean isExtShowCompleted() {
        return extShowCompleted;
    }

    public void setExtShowCompleted(boolean extShowCompleted) {
        this.extShowCompleted = extShowCompleted;
    }

    public String getExtFinishDate() {
        return extFinishDate;
    }

    public void setExtFinishDate(String extFinishDate) {
        this.extFinishDate = extFinishDate;
    }

    public int getPeriodType() {
        return periodType;
    }

    public void setPeriodType(int periodType) {
        this.periodType = periodType;
    }

    public boolean isHasExtSearchParams() {
        return hasExtSearchParams;
    }

    public void setHasExtSearchParams(boolean hasExtSearchParams) {
        this.hasExtSearchParams = hasExtSearchParams;
    }

    public boolean isAscSort() {
        return isAscSort;
    }

    public void setAscSort(boolean isAscSort) {
        this.isAscSort = isAscSort;
    }

    public String getSortColumn() {
        return sortColumn;
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
    }

    public String getObjectID() {
        return objectID;
    }

    public void setObjectID(String objectID) {
        this.objectID = objectID;
    }

    public String getFilterID() {
        return filterID;
    }

    public void setFilterID(String filterID) {
        this.filterID = filterID;
    }

    public String getFilterType() {
        return filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public String getUserID() {
        return userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getExtStartDate() {
        return extStartDate;
    }

    public void setExtStartDate(String extStartDate) {
        this.extStartDate = extStartDate;
    }

}
