package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

/**
 *
 * Класс демонстрирующий работу метода rejectWorkResult класса WorkFlowService
 *
 * Created by root on 7/3/14.
 */
public class WorkFlowServiceRejectWorkResult {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** UUID работы. */
    private String workID;
    /** UUID результата работы. */
    private String resultID;
    /** Дата время начала работы в формате yyyy-MM-dd HH:mm. */
    private String startDate;
    /** Дата время завершения работы в формате yyyy-MM-dd HH:mm. */
    private String finishDate;
    /** Измененный прогресс работы. */
    private String progress;
    /** Комментарий отклонения. */
    private String comment;

    public WorkFlowServiceRejectWorkResult(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void rejectWorkResult() throws Exception {
        URL url = new URL(address + "/rest/api/workflow/work/reject_result");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Cache-Control", "no-caches");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("workID=" + workID);
        request.writeBytes("&");
        request.writeBytes("resultID=" + resultID);
        request.writeBytes("&");
        request.writeBytes("startDate=" + startDate);
        request.writeBytes("&");
        request.writeBytes("finishDate=" + finishDate);
        request.writeBytes("&");
        request.writeBytes("progress=" + progress);
        request.writeBytes("&");
        request.writeBytes("comment=" + URLEncoder.encode(comment));
        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public void setWorkID(String workID) {
        this.workID = workID;
    }

    public void setResultID(String resultID) {
        this.resultID = resultID;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setFinishDate(String finishDate) {
        this.finishDate = finishDate;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}
